package com.hero.util;

import com.hero.HeroDesigner;
import com.hero.objects.characteristics.Characteristic;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class Constants {

	public static final int GENERAL = 0;

	public static final int STR = 1;

	public static final int DEX = 2;

	public static final int CON = 3;

	public static final int BODY = 4;

	public static final int INT = 5;

	public static final int EGO = 6;

	public static final int PRE = 7;

	public static final int COM = 8;

	public static final int PD = 9;

	public static final int ED = 10;

	public static final int SPD = 11;

	public static final int REC = 12;

	public static final int END = 13;

	public static final int STUN = 14;

	public static final int SIZE = 15;

	public static final int DEF = 16;

	public static final int RUNNING = 17;

	public static final int SWIMMING = 18;

	public static final int LEAPING = 19;

	public static final int CUSTOM1 = 20;

	public static final int CUSTOM2 = 21;

	public static final int CUSTOM3 = 22;

	public static final int CUSTOM4 = 23;

	public static final int CUSTOM5 = 24;

	public static final int CUSTOM6 = 25;

	public static final int CUSTOM7 = 26;

	public static final int CUSTOM8 = 27;

	public static final int CUSTOM9 = 28;

	public static final int CUSTOM10 = 29;
	
	public static final int OCV = 30;
	
	public static final int DCV = 31;
	
	public static final int OMCV = 32;
	
	public static final int DMCV = 33;

	public static final int IMAGE_WIDTH = 300;

	public static final int COL_1_WIDTH = 60;

	public static final int COL_2_WIDTH = 300;

	public static final int COL_3_WIDTH = 40;

	/**
	 * Returns the matching integer type identifier for the Characteristic
	 * string.
	 * 
	 * @param characteristic
	 * @return
	 */
	public static int getCharacteristicInteger(String characteristic) {
		characteristic = characteristic.trim().toUpperCase();
		if (HeroDesigner.getActiveHero() != null) {
			for (int i = 0; i < HeroDesigner.getActiveHero()
					.getCharacteristics().size(); i++) {
				Characteristic c = (Characteristic) HeroDesigner
						.getActiveHero().getCharacteristics().get(i);
				if (c.getDisplay().trim().toUpperCase().equals(characteristic)) {
					return c.getType();
				}
			}
		}
		if (characteristic.equals("GENERAL")) {
			return 0;
		} else if (characteristic.equals("STR")) {
			return 1;
		} else if (characteristic.equals("DEX")) {
			return 2;
		} else if (characteristic.equals("CON")) {
			return 3;
		} else if (characteristic.equals("BODY")) {
			return 4;
		} else if (characteristic.equals("INT")) {
			return 5;
		} else if (characteristic.equals("EGO")) {
			return 6;
		} else if (characteristic.equals("PRE")) {
			return 7;
		} else if (characteristic.equals("COM")) {
			return 8;
		} else if (characteristic.equals("PD")) {
			return 9;
		} else if (characteristic.equals("ED")) {
			return 10;
		} else if (characteristic.equals("SPD")) {
			return 11;
		} else if (characteristic.equals("REC")) {
			return 12;
		} else if (characteristic.equals("END")) {
			return 13;
		} else if (characteristic.equals("STUN")) {
			return 14;
		} else if (characteristic.equals("SIZE")) {
			return 15;
		} else if (characteristic.equals("DEF")) {
			return 16;
		} else if (characteristic.equals("RUNNING")) {
			return 17;
		} else if (characteristic.equals("SWIMMING")) {
			return 18;
		} else if (characteristic.equals("LEAPING")) {
			return 19;
		} else if (characteristic.equals("CUSTOM1")) {
			return Constants.CUSTOM1;
		} else if (characteristic.equals("CUSTOM2")) {
			return Constants.CUSTOM2;
		} else if (characteristic.equals("CUSTOM3")) {
			return Constants.CUSTOM3;
		} else if (characteristic.equals("CUSTOM4")) {
			return Constants.CUSTOM4;
		} else if (characteristic.equals("CUSTOM5")) {
			return Constants.CUSTOM5;
		} else if (characteristic.equals("CUSTOM6")) {
			return Constants.CUSTOM6;
		} else if (characteristic.equals("CUSTOM7")) {
			return Constants.CUSTOM7;
		} else if (characteristic.equals("CUSTOM8")) {
			return Constants.CUSTOM8;
		} else if (characteristic.equals("CUSTOM9")) {
			return Constants.CUSTOM9;
		} else if (characteristic.equals("CUSTOM10")) {
			return Constants.CUSTOM10;
		} else if (characteristic.equals("OCV")) {
			return Constants.OCV;
		} else if (characteristic.equals("DCV")) {
			return Constants.DCV;
		} else if (characteristic.equals("OMCV")) {
			return Constants.OMCV;
		} else if (characteristic.equals("DMCV")) {
			return Constants.DMCV;
		} else {
			return 0;
		}
	}

	/**
	 * Returns the matching Characteristic string for the specified
	 * Characteristic type integer.
	 * 
	 * @param characteristic
	 * @return
	 */
	public static String getCharacteristicString(int characteristic) {
		if ((HeroDesigner.getActiveHero() != null)
				&& (HeroDesigner.getActiveHero().getCharacteristic(
						characteristic) != null)) {
			Characteristic c = HeroDesigner.getActiveHero().getCharacteristic(
					characteristic);
			return c.getDisplay();
		}
		switch (characteristic) {
		case GENERAL:
			return "GENERAL";
		case STR:
			return "STR";
		case DEX:
			return "DEX";
		case CON:
			return "CON";
		case BODY:
			return "BODY";
		case INT:
			return "INT";
		case EGO:
			return "EGO";
		case PRE:
			return "PRE";
		case COM:
			return "COM";
		case PD:
			return "PD";
		case ED:
			return "ED";
		case SPD:
			return "SPD";
		case REC:
			return "REC";
		case END:
			return "END";
		case STUN:
			return "STUN";
		case SIZE:
			return "SIZE";
		case DEF:
			return "DEF";
		case RUNNING:
			return "RUNNING";
		case SWIMMING:
			return "SWIMMING";
		case LEAPING:
			return "LEAPING";
		case OCV:
			return "OCV";
		case DCV:
			return "DCV";
		case OMCV:
			return "OMCV";
		case DMCV:
			return "DMCV";
		default:
			return "GENERAL";
		}
	}
}